<a name="EN-Doc"></a>
## 1. Partition Table
Partition table is added since ESP8266\_NonOS\_SDK_V3.0, see `partition_item_t` in `include/user_interface.h`. Users can configure the flash partitions in user application, and adjusting some partitions' addresses and sizes according to practical needs.  
Users can refer to `ESP8266_NONOS_SDK/examples/IoT_Demo/user/user_main.c` to set partition table. Please note the following items: 

- Call `system_partition_table_regist` in `user_pre_init` to register partition table:
    - `system_partition_table_regist` will check if there is any overwrite conflict. If there is, it will return false, and then you need to revise your partition table.
    - The 3rd parameter of `system_partition_table_regist` should be the actual flash map corresponding to the one you choose in compiling and downloading. It is suggested that you can use `SPI_FLASH_SIZE_MAP`, which is set by the system while compiling, as the 3rd parameter.
- boot.bin MUST be at address 0x0.
- user1.bin MUST be at address 0x1000.
- user2.bin:
    - For 512+512 map, MUST be at address 0x81000.
    - For 1024+1024 map, MUST be at address 0x101000.

Partition types are defined in `ESP8266_NonOS_SDK/include/user_interface.h`:

```  
typedef enum {
    SYSTEM_PARTITION_INVALID = 0,
    SYSTEM_PARTITION_BOOTLOADER,            /* user can't modify this partition address */
    SYSTEM_PARTITION_OTA_1,                 /* user can't modify this partition address, but can modify its size */
    SYSTEM_PARTITION_OTA_2,                 /* user can't modify this partition address, but can modify its size */
    SYSTEM_PARTITION_RF_CAL,                /* user must define this partition */
    SYSTEM_PARTITION_PHY_DATA,              /* user must define this partition */
    SYSTEM_PARTITION_SYSTEM_PARAMETER,      /* user must define this partition */
    SYSTEM_PARTITION_AT_PARAMETER,
    SYSTEM_PARTITION_SSL_CLIENT_CERT_PRIVKEY,
    SYSTEM_PARTITION_SSL_CLIENT_CA,
    SYSTEM_PARTITION_SSL_SERVER_CERT_PRIVKEY,
    SYSTEM_PARTITION_SSL_SERVER_CA,
    SYSTEM_PARTITION_WPA2_ENTERPRISE_CERT_PRIVKEY,
    SYSTEM_PARTITION_WPA2_ENTERPRISE_CA,
    
    SYSTEM_PARTITION_CUSTOMER_BEGIN = 100,  /* user can add user-defined partitions after this item */
    SYSTEM_PARTITION_MAX
} partition_type_t;
```
* `SYSTEM_PARTITION_RF_CAL`, `SYSTEM_PARTITION_PHY_DATA` and `SYSTEM_PARTITION_SYSTEM_PARAMETER` have to be defined in the partition table in application. User can change their addresses according to practical needs. 
* If you need to add user-defined partitions, please add them after `SYSTEM_PARTITION_CUSTOMER_BEGIN`, and then define them in the partition table in application. Then, the system will check all user-defined partitions and original system partitions when start-up.

## 2. Non-FOTA Map
To use non-FOTA map, users can add user-defined partitions after `SYSTEM_PARTITION_CUSTOMER_BEGIN` as the following example:

```
#define EAGLE_FLASH_BIN_ADDR				（SYSTEM_PARTITION_CUSTOMER_BEGIN + 1）
#define EAGLE_IROM0TEXT_BIN_ADDR			（SYSTEM_PARTITION_CUSTOMER_BEGIN + 2）

static const partition_item_t partition_table[] = {
    { EAGLE_FLASH_BIN_ADDR, 	0x00000, 0x10000},
    { EAGLE_IROM0TEXT_BIN_ADDR, 0x10000, 0x60000},
    { SYSTEM_PARTITION_RF_CAL, SYSTEM_PARTITION_RF_CAL_ADDR, 0x1000},
    { SYSTEM_PARTITION_PHY_DATA, SYSTEM_PARTITION_PHY_DATA_ADDR, 0x1000},
    { SYSTEM_PARTITION_SYSTEM_PARAMETER,SYSTEM_PARTITION_SYSTEM_PARAMETER_ADDR, 0x3000},
};

void ICACHE_FLASH_ATTR user_pre_init(void)
{
    if(!system_partition_table_regist(partition_table, sizeof(partition_table)/sizeof(partition_table[0]),SPI_FLASH_SIZE_MAP)) {
		os_printf("system_partition_table_regist fail\r\n");
		while(1);
	}
}

```

## 3. AT: 512+512 map
Limited by the size of the AT bin files, since ESP8266\_NonOS\_SDK_V3.0, `512+512 flash map` is NOT supported in default AT firmware. 
But users can try to configure 512+512 map by modifying AT application, adjusting partition table and recompiling it, as following steps:

* Remove some functions to reduce the size of user.bin which generated by compiling AT application. Please note that the size of user.bin should less than `SYSTEM_PARTITION_OTA_SIZE`. For example, to reduce the bin size, you can change from using libmbedtls to libssl, or remove SmartConfig.
* Configure user-defined partition table:

```
#define SYSTEM_PARTITION_OTA_SIZE			                        0x6A000  // upper limit for user.bin
#define SYSTEM_PARTITION_OTA_2_ADDR		                        0x81000
#define SYSTEM_PARTITION_RF_CAL_ADDR		                        0xfb000
#define SYSTEM_PARTITION_PHY_DATA_ADDR	                        0xfc000
#define SYSTEM_PARTITION_SYSTEM_PARAMETER_ADDR                  0xfd000
#define SYSTEM_PARTITION_AT_PARAMETER_ADDR.                     0x7d000
#define SYSTEM_PARTITION_SSL_CLIENT_CERT_PRIVKEY_ADDR           0x7c000
#define SYSTEM_PARTITION_SSL_CLIENT_CA_ADDR.                    0x7b000
#define SYSTEM_PARTITION_WPA2_ENTERPRISE_CERT_PRIVKEY_ADDR      0x7a000
#define SYSTEM_PARTITION_WPA2_ENTERPRISE_CA_ADDR                0x79000
```
